################################################################################
################################################################################
#
#			Democratic Effect of DD
#
#			March, 2015
#			Lucas Leemann and Fabio Wasserfallen
#			l.leemann@ucl.ac.uk & wasserfallen@ipz.uzh.ch
#			
################################################################################
################################################################################
			
			
#rm(list=ls())


################################################################################
#			Set Working Directory
################################################################################

setwd(your_path)



################################################################################
#			Create DATA
################################################################################

##### ELITE Preference estimates with GOVERNMENT (not parliament) -- posterior draws
load("predictions.GOVpreference1.RData")
gov.preferences.w.unc <- predictions.allpol.wUNCERT

##### PEOPLE Preference estimates -- posterior draws
load("predictions.CIT.BIC_new.RData")
citizen.preferences.w.unc <- predictions.allpol.wUNCERT



############# Get the Preference means #############

# GOV Preferences
gov.preference <- matrix(NA, 26, 10)
for (i in 1:26){
	for (j in 1:10){
		gov.preference[i,j] <- 	mean(gov.preferences.w.unc[i,j,])
	}	
}

# Citizen Preferences
citizen.preference <- matrix(NA, 26, 10)

for (i in 1:26){
	for (j in 1:10){
		citizen.preference[i,j] <- 	mean(citizen.preferences.w.unc[i,j,])
	}	
}



#############  Get existing policies ############# 
existing.policy.data <- read.dta("Policies1.dta")
existing.policy.data <- existing.policy.data





####################################################    
# Create Basic Data Structure
# it will have length k*p (cantons times policies) and it starts with policy 1 
# (ZH, BE, LU, ...), then policy 2 (ZH, BE, LU, ...), .....

exist.pol <- as.matrix(existing.policy.data[,-c(1:3)])
gov.preference.vec <- c(gov.preference)
citizen.preference.vec <- c(citizen.preference)
existing.policy.data.vec <- c(exist.pol)
cantonnr <- rep(c(1:26),10)
policynr <- rep(1,26)
	for(i in 2:10){
		a <- rep(i,26)
		policynr <- c(policynr,a)
	}

# Policy names
policy.names <- c(rep("PauschBest",26), rep("Progression",26), rep("Steuerlevel",26), rep("Kinderabzug",26), rep("AusStimmrecht",26), rep("Einburgerung",26),rep("2FremdSprJahr",26), rep("PramVerAuto",26), rep("PramVerLevel",26), rep("MedAbgabe",26))





####################################################    
# Adding Covariates

citizen.opinion.clarity <- abs(citizen.preference.vec-0.5)
gov.opinion.clarity <- abs(gov.preference.vec-0.5)

# Prepare for congruence measures (dichotomize)
gov.preference.bin <- ifelse(gov.preference.vec>0.5,1,0)
citizen.preference.bin <- ifelse(citizen.preference.vec>0.5,1,0)

# Citizen-policy congruence
cit.pol.congruence <- ifelse(citizen.preference.bin==existing.policy.data.vec,1,0)
cit.pol.congruence14 <- rep(0, length(cit.pol.congruence))
cit.pol.congruence14[citizen.opinion.clarity>.15 & cit.pol.congruence==1] <- 3
cit.pol.congruence14[citizen.opinion.clarity<.15 ] <- 2
cit.pol.congruence14[citizen.opinion.clarity>.15 & cit.pol.congruence==0] <- 1

cit.pol.congruence.cont <- citizen.preference.vec
cit.pol.congruence.cont[existing.policy.data.vec==0] <- -cit.pol.congruence.cont[existing.policy.data.vec==0]

# Elite-citizen congruence (gov and parliament) 
cit.gov.congruence <- ifelse(gov.preference.bin==citizen.preference.bin,1,0)

# Gov-citizen gap gov (absolute value), set to 0 if both prefer/reject a policy
gov.cit.gap.1 <- abs(gov.preference.vec-citizen.preference.vec)
gov.cit.gap.1[cit.gov.congruence==1] <- 0

gov.cit.gap.2 <- abs(gov.preference.vec-citizen.preference.vec)
gov.cit.gap.2[cit.gov.congruence==1] <- 0
gov.cit.gap.2[gov.cit.gap.2<0.1] <- 0



gov.cit.gap.3 <- abs(gov.preference.vec-citizen.preference.vec)
gov.cit.gap.3[cit.gov.congruence==1] <- -abs(gov.preference.vec[cit.gov.congruence==1]-citizen.preference.vec[cit.gov.congruence==1])
gov.cit.gap.3[cit.gov.congruence==0] <- abs(gov.preference.vec[cit.gov.congruence==0]-citizen.preference.vec[cit.gov.congruence==0])


gov.cit.gap.4 <- abs(gov.preference.vec-citizen.preference.vec)
gov.cit.gap.4[cit.gov.congruence==1] <- abs(gov.preference.vec[cit.gov.congruence==1]-citizen.preference.vec[cit.gov.congruence==1])
gov.cit.gap.4[cit.gov.congruence==0] <- .5 + abs(gov.preference.vec[cit.gov.congruence==0]-citizen.preference.vec[cit.gov.congruence==0])




gov.cit.gap.raw <- gov.preference.vec-citizen.preference.vec

# Elite-citizen gap absoulte difference
gov.cit.gap.abs <- abs(gov.preference.vec-citizen.preference.vec)

# Context variables
context.data <- read.dta("Context Data.dta")
context.data[,4] <- context.data[,4]/100000
context.data[,8] <- context.data[,8]/100

context.data.mat <- rbind(context.data, context.data, context.data, context.data, context.data, context.data, context.data, context.data, context.data, context.data)


ProMaj <- read.dta("proporzMajorzVatter.dta")
ProMaj <- ProMaj[,-1]
ProMajL <- rbind(ProMaj,ProMaj,ProMaj,ProMaj,ProMaj,ProMaj,ProMaj,ProMaj,ProMaj,ProMaj)

context.data.mat <- cbind(context.data.mat,ProMajL)


# read Bochlser Data to government elections
MajGov <- read.dta("BochslerRegierungswahlen.dta")
MajGov[,6] <- MajGov[,6]/100
MajGovL <- rbind(MajGov,MajGov,MajGov,MajGov,MajGov,MajGov,MajGov,MajGov,MajGov,MajGov)
context.data.mat <- cbind(context.data.mat,ProMajL)

context.data.mat <- cbind(context.data.mat,MajGovL)


# Citizen preference measure with NA if mean between 0.45 - 0.55 (better alternative: select according to uncertainty of the measure)
citizen.preference.vec.2 <- citizen.preference.vec
citizen.preference.vec.2[citizen.preference.vec>0.45&citizen.preference.vec<0.55] <- NA
citizen.preference.bin.2 <- ifelse(citizen.preference.vec.2>0.5,1,0)
cit.pol.congruence.2 <- ifelse(citizen.preference.bin.2==existing.policy.data.vec,1,0)


# Share of satisified citizens
satisfied <- rep(NA, length(existing.policy.data.vec))
satisfied[existing.policy.data.vec==1] <- citizen.preference.vec[existing.policy.data.vec==1]
satisfied[existing.policy.data.vec==0] <- 1-citizen.preference.vec[existing.policy.data.vec==0]

####################################################  
# Make big data set

big.data <- cbind(cantonnr, policynr, citizen.preference.vec, gov.preference.vec, citizen.preference.bin, citizen.opinion.clarity,  existing.policy.data.vec,  cit.gov.congruence, cit.pol.congruence, cit.pol.congruence.2,  context.data.mat, satisfied, gov.cit.gap.1, gov.cit.gap.2, gov.cit.gap.3,gov.cit.gap.4, gov.cit.gap.abs, gov.opinion.clarity,cit.pol.congruence14,cit.pol.congruence.cont)

gap0 <- rep(1,length(big.data$gov.cit.gap.1))
gap0[big.data$gov.cit.gap.1==0] <- 0

####################################################  
# Add SVP party strength
svp.data <- read.dta("SVP by canton.dta")
svp <- svp.data[,3]
SVP <- c(svp,svp,svp,svp,svp,svp,svp,svp,svp,svp)


#############  Get DD voting data ############# 

policies.DDvoteBin.data <- read.dta("PoliciesDDvoteBin.dta")
policies.DDvoteBin.data3 <- read.dta("PoliciesDDvoteT-3_updated.dta") #read.dta("Final Data/PoliciesDDvoteBin_t3.dta")
policies.DDvoteBin.data5 <- read.dta("PoliciesDDvoteBin_t5.dta")

policies.DDvoteYear.data <- read.dta("PoliciesDDvoteYear.dta")

policies.DDvoteBin <- c(policies.DDvoteBin.data$pol1,policies.DDvoteBin.data$pol2,policies.DDvoteBin.data$pol3,policies.DDvoteBin.data$pol4,policies.DDvoteBin.data$pol5,policies.DDvoteBin.data$pol6,policies.DDvoteBin.data$pol7,policies.DDvoteBin.data$pol8,policies.DDvoteBin.data$pol9,policies.DDvoteBin.data$pol10)

policies.DDvoteBin3 <- c(policies.DDvoteBin.data3$pol1,policies.DDvoteBin.data3$pol2,policies.DDvoteBin.data3$pol3, policies.DDvoteBin.data3$pol4, policies.DDvoteBin.data3$pol5, policies.DDvoteBin.data3$pol6, policies.DDvoteBin.data3$pol7, policies.DDvoteBin.data3$pol8, policies.DDvoteBin.data3$pol9, policies.DDvoteBin.data3$pol10)

policies.DDvoteBin5 <- c(policies.DDvoteBin.data5$pol1,policies.DDvoteBin.data5$pol2,policies.DDvoteBin.data5$pol3, policies.DDvoteBin.data5$pol4, policies.DDvoteBin.data5$pol5, policies.DDvoteBin.data5$pol6, policies.DDvoteBin.data5$pol7, policies.DDvoteBin.data5$pol8, policies.DDvoteBin.data5$pol9, policies.DDvoteBin.data5$pol10)

policies.DDvoteYear <- c(policies.DDvoteYear.data$pol1,policies.DDvoteYear.data$pol2,policies.DDvoteYear.data$pol3,policies.DDvoteYear.data$pol4,policies.DDvoteYear.data$pol5,policies.DDvoteYear.data$pol6,policies.DDvoteYear.data$pol7,policies.DDvoteYear.data$pol8,policies.DDvoteYear.data$pol9,policies.DDvoteYear.data$pol10)


big.data <- cbind(big.data, SVP, policies.DDvoteBin, policies.DDvoteBin3, policies.DDvoteBin5, policies.DDvoteYear)


save.image(file="DataForCongruence.RData")